# SSH Erişimi Olmadan Kurulum Rehberi

Bu rehber, SSH erişimi olmayan sunucular için hazırlanmıştır.

## 🚀 Hızlı Kurulum (3 Yöntem)

### Yöntem 1: Web Tabanlı Kurulum Scripti (ÖNERİLEN) ⭐

En kolay yöntem! Otomatik kurulum scripti kullanın.

#### Adımlar:

1. **cPanel'den Veritabanı Oluştur**
   - cPanel → MySQL Databases
   - Yeni veritabanı oluştur (örn: `ticketsys_db`)
   - Yeni kullanıcı oluştur ve TÜM YETKİLERİ ver
   - Bilgileri not et

2. **Dosyaları Yükle**
   - Tüm proje dosyalarını FTP/cPanel File Manager ile sunucuya yükle
   - `vendor/` klasörünü de yükle (yerelde `composer install` sonrası)

3. **Kurulum Scriptini Çalıştır**
   - Tarayıcıda: `https://yourdomain.com/install.php`
   - Formu doldur ve adım adım takip et
   - Script otomatik olarak:
     - .env dosyası oluşturur
     - Veritabanı bağlantısını test eder
     - Key generate yapar
     - Migration'ları çalıştırır
     - Storage link oluşturur
     - Varsayılan kullanıcıları oluşturur

4. **Kurulum Sonrası**
   - **ÖNEMLİ:** `install.php` dosyasını silin!
   - Site hazır: `https://yourdomain.com`
   - Admin: `https://yourdomain.com/admin/dashboard`
   - Giriş: `admin@example.com` / `password`

**✅ Bu yöntem en pratik ve güvenlidir!**

---

### Yöntem 2: SQL Dosyası ile Manuel Kurulum

Eğer web scripti çalışmazsa bu yöntemi kullanın.

#### Adımlar:

1. **cPanel'den Veritabanı Oluştur** (Yöntem 1 ile aynı)

2. **Dosyaları Yükle** (Yöntem 1 ile aynı)

3. **.env Dosyasını Oluştur**
   - `public` klasörünün bir üst dizininde `.env` dosyası oluştur
   - İçine şunu yaz:

```env
APP_NAME="Ticket System"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=kullanici_veritabani_adi
DB_USERNAME=kullanici_kullanici_adi
DB_PASSWORD=şifre

SESSION_DRIVER=file
CACHE_DRIVER=file
```

4. **APP_KEY Oluştur**
   - Online tool kullan: https://generate-random.org/api-key-generator
   - 32 karakterlik random string oluştur
   - `.env` dosyasında: `APP_KEY=base64:OLUŞTURULAN_KEY_BURAYA`

5. **SQL Dosyasını İçe Aktar**
   - cPanel → phpMyAdmin
   - Veritabanınızı seçin
   - **Import** sekmesine tıklayın
   - `database/ticket_system.sql` dosyasını seçin
   - **Go** butonuna tıklayın

6. **Storage Link Oluştur**
   - cPanel File Manager'da
   - `public` klasörüne gidin
   - Yeni bir klasör oluşturun: `storage`
   - `storage/app/public` klasörünü `public/storage` ile bağlayın
   - Veya manuel olarak `public/storage` klasörü oluşturup içine `index.php` koyun

7. **İzinleri Ayarla**
   - `storage/` klasörü: 755
   - `bootstrap/cache/` klasörü: 755

**✅ Kurulum tamamlandı!**

---

### Yöntem 3: phpMyAdmin ile Manuel SQL

En manuel yöntem. Sadece gerekirse kullanın.

#### Adımlar:

1-2. Yöntem 1 ile aynı

3. **phpMyAdmin'de Tabloları Oluştur**
   - cPanel → phpMyAdmin
   - Veritabanınızı seçin
   - SQL sekmesine gidin
   - `database/ticket_system.sql` dosyasının içeriğini kopyalayıp yapıştırın
   - **Go** butonuna tıklayın

4-7. Yöntem 2 ile aynı

---

## 📋 Dosya Yapısı Kontrolü

Kurulumdan sonra şu yapı olmalı:

```
/public_html/
  ├── app/
  ├── bootstrap/
  ├── config/
  ├── database/
  │   └── ticket_system.sql
  ├── public/
  │   ├── install.php (kurulum sonrası silin!)
  │   ├── index.php
  │   └── .htaccess
  ├── resources/
  ├── routes/
  ├── storage/
  │   └── app/
  │       └── public/
  ├── vendor/
  ├── .env
  └── artisan
```

## 🔐 İlk Giriş Bilgileri

**Admin:**
- Email: `admin@example.com`
- Şifre: `password`

**Kullanıcı:**
- Email: `user@example.com`
- Şifre: `password`

**⚠️ GÜVENLİK:** İlk girişten sonra mutlaka şifreleri değiştirin!

## ✅ Kurulum Kontrol Listesi

- [ ] Veritabanı oluşturuldu
- [ ] Dosyalar yüklendi
- [ ] .env dosyası oluşturuldu ve düzenlendi
- [ ] APP_KEY oluşturuldu
- [ ] SQL dosyası içe aktarıldı (veya web scripti çalıştırıldı)
- [ ] Storage link oluşturuldu
- [ ] İzinler ayarlandı (755)
- [ ] install.php silindi (güvenlik)
- [ ] Site açılıyor
- [ ] Admin paneline giriş yapılabiliyor

## 🐛 Sorun Giderme

### "install.php çalışmıyor"
- PHP versiyonunun 8.1+ olduğundan emin olun
- `vendor/` klasörünün yüklendiğinden emin olun
- Hata loglarını kontrol edin

### "Veritabanı bağlantı hatası"
- .env dosyasındaki bilgileri kontrol edin
- cPanel'den kullanıcı adı ve şifreyi doğrulayın
- Veritabanı adının ön ekli halini kullandığınızdan emin olun

### "500 Internal Server Error"
- `.htaccess` dosyasının `public/` klasöründe olduğundan emin olun
- PHP hata loglarını kontrol edin
- `storage/` ve `bootstrap/cache/` klasörlerinin yazılabilir olduğundan emin olun

### "Class not found"
- `vendor/` klasörünün yüklendiğinden emin olun
- `composer install` komutunu yerelde çalıştırıp `vendor/` klasörünü yükleyin

## 📞 Yardım

Sorun yaşarsanız:
1. `storage/logs/laravel.log` dosyasını kontrol edin
2. cPanel'den PHP error loglarını kontrol edin
3. .env dosyasındaki tüm değerleri tekrar kontrol edin

## 🎉 Başarılı Kurulum!

Kurulum tamamlandıktan sonra:
1. Admin paneline giriş yapın
2. Ayarları yapın (Logo, SEO, Timezone)
3. Knowledge Base ekleyin
4. İlk ticket'ı test edin

**Başarılar!** 🚀

